###################################################
### code chunk number : set your work directory
###################################################
## 
## Firstly, set your work directory to contain "main_two_inequalities.R".
## Secondly, make sure there is a folder named "figure"
## in the same directory of "main_two_inequalities.R".
##


###################################################
### code chunk number : Simulations: Two inequalities: Given (alpha, beta)
###################################################
## 
##
rm(list=ls(all=TRUE))
source("subfunctions.R")

## Install the package for the first time.
## note: omit the 's' in 'https' if you cannot handle https downloads
# install.packages(pkgs = "gsl", repos = "https://cloud.r-project.org/", dependencies=TRUE)
library(gsl)

alpha = 3
beta = 1

set.seed(1)
theta_np1 = 1 / rgamma(n = 1, shape = alpha, scale = beta); theta_np1
x_np1 = runif(n = 1, min = 0, max = theta_np1); x_np1

res = Compute_Estimator_PESL_new(alpha, beta, x_np1); res

## 
## plot the posterior density
## 
Theta_1 = c(seq(0.01, 0.99, length = 30), seq(1, 4, length = 10))
f1 = 1 / (gamma(alpha + 1) * beta^(alpha + 1) * Theta_1^(alpha + 2) * exp(1 / (beta * Theta_1)))
y1 = f1; y1

Theta_2 = seq(x_np1, 4, length = 30)
f2 = 1 / (gamma(alpha + 1) * beta^(alpha + 1) * Theta_2^(alpha + 2) * exp(1 / (beta * Theta_2)))
F2 = pgamma(1/x_np1, shape = alpha + 1, scale = beta)
y2 = f2 / F2; y2

dev.new()
col = c("blue", "red")
lty = 1:2
xlim = range(Theta_1)
ylim = range(y1, y2)
# ylim=c(0:1)
plot(Theta_1, y1, type = "n", xlim = xlim, ylim = ylim, xlab = expression(theta[n+1]), ylab = "density")
lines(Theta_1, y1, lty = lty[1], col = col[1], lwd = 4)
lines(Theta_2, y2, lty = lty[2], col = col[2], lwd = 4)
leg.txt = c("IG density", "TIG density")
legend(x = "topright", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/U-IG_IG_TIG_density", sep = ""), type = c("pdf"))
savePlot(filename = paste("figure/U-IG_IG_TIG_density", sep = ""), type = c("jpg"))


####################################################
### code chunk number : Simulations: Two inequalities, alpha changes
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")
library(gsl)

## initialization
alpha = 1:10
beta = 1
L_alpha = length(alpha)

set.seed(1)
theta_np1 = 1 / rgamma(n = 1, shape = 3, scale = 1); theta_np1
x_np1 = runif(n = 1, min = 0, max = theta_np1); x_np1

delta_s = delta_2 = PESL_s = PESL_2 = rep(0, L_alpha)
for (i in 1:L_alpha){
	res_i = Compute_Estimator_PESL_new(alpha[i], beta, x_np1)
	delta_s[i] = res_i$delta_s
	delta_2[i] = res_i$delta_2
	PESL_s[i] = res_i$PESL_s
	PESL_2[i] = res_i$PESL_2
}
delta_s
delta_2
PESL_s
PESL_2

## Generate_Matrix_Latex for B
B = round(rbind(delta_s, delta_2, PESL_s, PESL_2), 4)
Generate_Matrix_Latex(format(B, nsmall = 4))

## plot estimators and PESLs
plot_estimator(delta_s, delta_2, parameter = alpha, para_name = "alpha", xlab = expression(alpha), legend_pos = "topright", sub = "(a)")
plot_PESL(PESL_s, PESL_2, parameter = alpha, para_name = "alpha", xlab = expression(alpha), legend_pos = "topright", sub = "(b)")


####################################################
### code chunk number : Simulations: Two inequalities, beta changes
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")
library(gsl)

## initialization
alpha = 3
beta = 1:10
L_beta = length(beta)

set.seed(1)
theta_np1 = 1 / rgamma(n = 1, shape = 3, scale = 1); theta_np1
x_np1 = runif(n = 1, min = 0, max = theta_np1); x_np1

delta_s = delta_2 = PESL_s = PESL_2 = rep(0, L_beta)
for (i in 1:L_beta){
	res_i = Compute_Estimator_PESL_new(alpha, beta[i], x_np1)
	delta_s[i] = res_i$delta_s
	delta_2[i] = res_i$delta_2
	PESL_s[i] = res_i$PESL_s
	PESL_2[i] = res_i$PESL_2
}
delta_s
delta_2
PESL_s
PESL_2

## Generate_Matrix_Latex for B
B = round(rbind(delta_s, delta_2, PESL_s, PESL_2), 4)
Generate_Matrix_Latex(format(B, nsmall = 4))

## plot estimators and PESLs
plot_estimator(delta_s, delta_2, parameter = beta, para_name = "beta", xlab = expression(beta), legend_pos = "topright", sub = "(c)")
plot_PESL(PESL_s, PESL_2, parameter = beta, para_name = "beta", xlab = expression(beta), legend_pos = "topright", sub = "(d)")


####################################################
### code chunk number : Simulations: Two inequalities, x_np1 changes
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")
library(gsl)

## initialization
alpha = 3
beta = 1
x_np1 = seq(from = 0.5, by = 0.5, length = 10); x_np1
L_x = length(x_np1); L_x

delta_s = delta_2 = PESL_s = PESL_2 = rep(0, L_x)
for (i in 1:L_x){
	res_i = Compute_Estimator_PESL_new(alpha, beta, x_np1[i])
	delta_s[i] = res_i$delta_s
	delta_2[i] = res_i$delta_2
	PESL_s[i] = res_i$PESL_s
	PESL_2[i] = res_i$PESL_2
}
delta_s
delta_2
PESL_s
PESL_2

## Generate_Matrix_Latex for B
B = round(rbind(delta_s, delta_2, PESL_s, PESL_2), 4)
Generate_Matrix_Latex(format(B, nsmall = 4))

## plot estimators and PESLs
plot_estimator(delta_s, delta_2, parameter = x_np1, para_name = "x_np1", xlab = expression(x[n+1]), legend_pos = "bottomright", sub = "(e)")
plot_PESL(PESL_s, PESL_2, parameter = x_np1, para_name = "x_np1", xlab = expression(x[n+1]), legend_pos = "topright", sub = "(f)")


###################################################
### code chunk number : Simulations: Two inequalities: persp3d
###################################################
##
## delta_s <= delta_2
## PESL_s <= PESL_2
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")
library(rgl) ## Install the R package rgl first.
L = 20
a = seq(0.1, 10, length = L); L_a = length(a); L_a
b = seq(0.1, 10, length = L); L_b = length(b); L_b

################
x_np1 = 0.5
################

## 
## Estimators
## 

z_delta_2 = outer(a, b, FUN = "delta_2")
range(z_delta_2)
dim(z_delta_2)

z_delta_s = outer(a, b, FUN = "delta_s")
range(z_delta_s)
dim(z_delta_s)

range(z_delta_2 - z_delta_s)

z_delta_2_s = outer(a, b, FUN = "delta_2_s")
range(z_delta_2_s)

open3d()
persp3d(a, b, z_delta_2_s,  col = "green", xlab = "a", ylab = "b", zlab = "delta[2](x) - delta[s](x)")
rgl.postscript("figure/delta_2_s_x_np1_0p5.pdf", "pdf")

## 
## PESLs
## 

z_PESL_2 = z_PESL_s = z_PESL_2_s = matrix(0, nrow = L_a, ncol = L_b)
for (i in 1:L_a){
	for (j in 1:L_b){
		z_PESL_2[i, j] = PESL_2(a[i], b[j])
		z_PESL_s[i, j] = PESL_s(a[i], b[j])
		z_PESL_2_s[i, j] = PESL_2_s(a[i], b[j])
	}
}
range(z_PESL_2)
dim(z_PESL_2)
range(z_PESL_s)
dim(z_PESL_s)
range(z_PESL_2 - z_PESL_s)
range(z_PESL_2_s)

open3d()
persp3d(a, b, z_PESL_2_s, col = "green", xlab = "a", ylab = "b", zlab = "PESL[2](x) - PESL[s](x)")
rgl.postscript("figure/PESL_2_s_x_np1_0p5.pdf", "pdf")


################
x_np1 = 2
################

## 
## Estimators
## 

z_delta_2 = outer(a, b, FUN = "delta_2")
range(z_delta_2)
dim(z_delta_2)

z_delta_s = outer(a, b, FUN = "delta_s")
range(z_delta_s)
dim(z_delta_s)

range(z_delta_2 - z_delta_s)

z_delta_2_s = outer(a, b, FUN = "delta_2_s")
range(z_delta_2_s)

open3d()
persp3d(a, b, z_delta_2_s,  col = "green", xlab = "a", ylab = "b", zlab = "delta[2](x) - delta[s](x)")
rgl.postscript("figure/delta_2_s_x_np1_2.pdf", "pdf")

## 
## PESLs
## 

z_PESL_2 = z_PESL_s = z_PESL_2_s = matrix(0, nrow = L_a, ncol = L_b)
for (i in 1:L_a){
	for (j in 1:L_b){
		z_PESL_2[i, j] = PESL_2(a[i], b[j])
		z_PESL_s[i, j] = PESL_s(a[i], b[j])
		z_PESL_2_s[i, j] = PESL_2_s(a[i], b[j])
	}
}
range(z_PESL_2)
dim(z_PESL_2)
range(z_PESL_s)
dim(z_PESL_s)
range(z_PESL_2 - z_PESL_s)
range(z_PESL_2_s)

open3d()
persp3d(a, b, z_PESL_2_s, col = "green", xlab = "a", ylab = "b", zlab = "PESL[2](x) - PESL[s](x)")
rgl.postscript("figure/PESL_2_s_x_np1_2.pdf", "pdf")

